package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{KmsKeyId, S3Uri}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PiiOutputDataConfig(
    s3Uri: S3Uri,
    kmsKeyId: Option[KmsKeyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.PiiOutputDataConfig = {
    import PiiOutputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.PiiOutputDataConfig
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.PiiOutputDataConfig.ReadOnly =
    zio.aws.comprehend.model.PiiOutputDataConfig.wrap(buildAwsValue())
}
object PiiOutputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.PiiOutputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.PiiOutputDataConfig =
      zio.aws.comprehend.model
        .PiiOutputDataConfig(s3Uri, kmsKeyId.map(value => value))
    def s3Uri: S3Uri
    def kmsKeyId: Option[KmsKeyId]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.PiiOutputDataConfig
  ) extends zio.aws.comprehend.model.PiiOutputDataConfig.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.comprehend.model.primitives.S3Uri(impl.s3Uri())
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.PiiOutputDataConfig
  ): zio.aws.comprehend.model.PiiOutputDataConfig.ReadOnly = new Wrapper(impl)
}
