package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  VersionName,
  Timestamp,
  Integer,
  ComprehendArnName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class EntityRecognizerSummary(
    recognizerName: Option[ComprehendArnName] = None,
    numberOfVersions: Option[Integer] = None,
    latestVersionCreatedAt: Option[Timestamp] = None,
    latestVersionName: Option[VersionName] = None,
    latestVersionStatus: Option[zio.aws.comprehend.model.ModelStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityRecognizerSummary = {
    import EntityRecognizerSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerSummary
      .builder()
      .optionallyWith(
        recognizerName.map(value =>
          ComprehendArnName.unwrap(value): java.lang.String
        )
      )(_.recognizerName)
      .optionallyWith(
        numberOfVersions.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.numberOfVersions)
      .optionallyWith(
        latestVersionCreatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestVersionCreatedAt)
      .optionallyWith(
        latestVersionName.map(value =>
          VersionName.unwrap(value): java.lang.String
        )
      )(_.latestVersionName)
      .optionallyWith(latestVersionStatus.map(value => value.unwrap))(
        _.latestVersionStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly =
    zio.aws.comprehend.model.EntityRecognizerSummary.wrap(buildAwsValue())
}
object EntityRecognizerSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EntityRecognizerSummary =
      zio.aws.comprehend.model.EntityRecognizerSummary(
        recognizerName.map(value => value),
        numberOfVersions.map(value => value),
        latestVersionCreatedAt.map(value => value),
        latestVersionName.map(value => value),
        latestVersionStatus.map(value => value)
      )
    def recognizerName: Option[ComprehendArnName]
    def numberOfVersions: Option[Integer]
    def latestVersionCreatedAt: Option[Timestamp]
    def latestVersionName: Option[VersionName]
    def latestVersionStatus: Option[zio.aws.comprehend.model.ModelStatus]
    def getRecognizerName: ZIO[Any, AwsError, ComprehendArnName] =
      AwsError.unwrapOptionField("recognizerName", recognizerName)
    def getNumberOfVersions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfVersions", numberOfVersions)
    def getLatestVersionCreatedAt: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("latestVersionCreatedAt", latestVersionCreatedAt)
    def getLatestVersionName: ZIO[Any, AwsError, VersionName] =
      AwsError.unwrapOptionField("latestVersionName", latestVersionName)
    def getLatestVersionStatus
        : ZIO[Any, AwsError, zio.aws.comprehend.model.ModelStatus] =
      AwsError.unwrapOptionField("latestVersionStatus", latestVersionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerSummary
  ) extends zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly {
    override val recognizerName: Option[ComprehendArnName] = scala
      .Option(impl.recognizerName())
      .map(value =>
        zio.aws.comprehend.model.primitives.ComprehendArnName(value)
      )
    override val numberOfVersions: Option[Integer] = scala
      .Option(impl.numberOfVersions())
      .map(value => zio.aws.comprehend.model.primitives.Integer(value))
    override val latestVersionCreatedAt: Option[Timestamp] = scala
      .Option(impl.latestVersionCreatedAt())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val latestVersionName: Option[VersionName] = scala
      .Option(impl.latestVersionName())
      .map(value => zio.aws.comprehend.model.primitives.VersionName(value))
    override val latestVersionStatus
        : Option[zio.aws.comprehend.model.ModelStatus] = scala
      .Option(impl.latestVersionStatus())
      .map(value => zio.aws.comprehend.model.ModelStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerSummary
  ): zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly = new Wrapper(
    impl
  )
}
