package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEndpointsResponse(
    endpointPropertiesList: Option[
      Iterable[zio.aws.comprehend.model.EndpointProperties]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListEndpointsResponse = {
    import ListEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListEndpointsResponse
      .builder()
      .optionallyWith(
        endpointPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpointPropertiesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.ListEndpointsResponse.ReadOnly =
    zio.aws.comprehend.model.ListEndpointsResponse.wrap(buildAwsValue())
}
object ListEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ListEndpointsResponse =
      zio.aws.comprehend.model.ListEndpointsResponse(
        endpointPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def endpointPropertiesList
        : Option[List[zio.aws.comprehend.model.EndpointProperties.ReadOnly]]
    def nextToken: Option[String]
    def getEndpointPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.EndpointProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "endpointPropertiesList",
      endpointPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListEndpointsResponse
  ) extends zio.aws.comprehend.model.ListEndpointsResponse.ReadOnly {
    override val endpointPropertiesList
        : Option[List[zio.aws.comprehend.model.EndpointProperties.ReadOnly]] =
      scala
        .Option(impl.endpointPropertiesList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.EndpointProperties.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListEndpointsResponse
  ): zio.aws.comprehend.model.ListEndpointsResponse.ReadOnly = new Wrapper(impl)
}
