package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.CustomerInputString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDetectEntitiesRequest(
    textList: Iterable[CustomerInputString],
    languageCode: zio.aws.comprehend.model.LanguageCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest = {
    import BatchDetectEntitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest
      .builder()
      .textList(textList.map { item =>
        CustomerInputString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .languageCode(languageCode.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.BatchDetectEntitiesRequest.ReadOnly =
    zio.aws.comprehend.model.BatchDetectEntitiesRequest.wrap(buildAwsValue())
}
object BatchDetectEntitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.BatchDetectEntitiesRequest =
      zio.aws.comprehend.model
        .BatchDetectEntitiesRequest(textList, languageCode)
    def textList: List[CustomerInputString]
    def languageCode: zio.aws.comprehend.model.LanguageCode
    def getTextList: ZIO[Any, Nothing, List[CustomerInputString]] =
      ZIO.succeed(textList)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.comprehend.model.LanguageCode] =
      ZIO.succeed(languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest
  ) extends zio.aws.comprehend.model.BatchDetectEntitiesRequest.ReadOnly {
    override val textList: List[CustomerInputString] = impl
      .textList()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.primitives.CustomerInputString(item)
      }
      .toList
    override val languageCode: zio.aws.comprehend.model.LanguageCode =
      zio.aws.comprehend.model.LanguageCode.wrap(impl.languageCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest
  ): zio.aws.comprehend.model.BatchDetectEntitiesRequest.ReadOnly = new Wrapper(
    impl
  )
}
