package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEntityRecognizerResponse(
    entityRecognizerProperties: Option[
      zio.aws.comprehend.model.EntityRecognizerProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerResponse = {
    import DescribeEntityRecognizerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerResponse
      .builder()
      .optionallyWith(
        entityRecognizerProperties.map(value => value.buildAwsValue())
      )(_.entityRecognizerProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeEntityRecognizerResponse.ReadOnly =
    zio.aws.comprehend.model.DescribeEntityRecognizerResponse
      .wrap(buildAwsValue())
}
object DescribeEntityRecognizerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DescribeEntityRecognizerResponse =
      zio.aws.comprehend.model.DescribeEntityRecognizerResponse(
        entityRecognizerProperties.map(value => value.asEditable)
      )
    def entityRecognizerProperties
        : Option[zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly]
    def getEntityRecognizerProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "entityRecognizerProperties",
      entityRecognizerProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerResponse
  ) extends zio.aws.comprehend.model.DescribeEntityRecognizerResponse.ReadOnly {
    override val entityRecognizerProperties
        : Option[zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly] =
      scala
        .Option(impl.entityRecognizerProperties())
        .map(value =>
          zio.aws.comprehend.model.EntityRecognizerProperties.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerResponse
  ): zio.aws.comprehend.model.DescribeEntityRecognizerResponse.ReadOnly =
    new Wrapper(impl)
}
