package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{Timestamp, JobName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SentimentDetectionJobFilter(
    jobName: Option[JobName] = None,
    jobStatus: Option[zio.aws.comprehend.model.JobStatus] = None,
    submitTimeBefore: Option[Timestamp] = None,
    submitTimeAfter: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.SentimentDetectionJobFilter = {
    import SentimentDetectionJobFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.SentimentDetectionJobFilter
      .builder()
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        submitTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTimeBefore)
      .optionallyWith(
        submitTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTimeAfter)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.SentimentDetectionJobFilter.ReadOnly =
    zio.aws.comprehend.model.SentimentDetectionJobFilter.wrap(buildAwsValue())
}
object SentimentDetectionJobFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.SentimentDetectionJobFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.SentimentDetectionJobFilter =
      zio.aws.comprehend.model.SentimentDetectionJobFilter(
        jobName.map(value => value),
        jobStatus.map(value => value),
        submitTimeBefore.map(value => value),
        submitTimeAfter.map(value => value)
      )
    def jobName: Option[JobName]
    def jobStatus: Option[zio.aws.comprehend.model.JobStatus]
    def submitTimeBefore: Option[Timestamp]
    def submitTimeAfter: Option[Timestamp]
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getSubmitTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTimeBefore", submitTimeBefore)
    def getSubmitTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTimeAfter", submitTimeAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.SentimentDetectionJobFilter
  ) extends zio.aws.comprehend.model.SentimentDetectionJobFilter.ReadOnly {
    override val jobName: Option[JobName] = scala
      .Option(impl.jobName())
      .map(value => zio.aws.comprehend.model.primitives.JobName(value))
    override val jobStatus: Option[zio.aws.comprehend.model.JobStatus] = scala
      .Option(impl.jobStatus())
      .map(value => zio.aws.comprehend.model.JobStatus.wrap(value))
    override val submitTimeBefore: Option[Timestamp] = scala
      .Option(impl.submitTimeBefore())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val submitTimeAfter: Option[Timestamp] = scala
      .Option(impl.submitTimeAfter())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.SentimentDetectionJobFilter
  ): zio.aws.comprehend.model.SentimentDetectionJobFilter.ReadOnly =
    new Wrapper(impl)
}
