package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  DocumentClassifierArn,
  IamRoleArn,
  AnyLengthString,
  Timestamp,
  KmsKeyId,
  VersionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DocumentClassifierProperties(
    documentClassifierArn: Option[DocumentClassifierArn] = None,
    languageCode: Option[zio.aws.comprehend.model.LanguageCode] = None,
    status: Option[zio.aws.comprehend.model.ModelStatus] = None,
    message: Option[AnyLengthString] = None,
    submitTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    trainingStartTime: Option[Timestamp] = None,
    trainingEndTime: Option[Timestamp] = None,
    inputDataConfig: Option[
      zio.aws.comprehend.model.DocumentClassifierInputDataConfig
    ] = None,
    outputDataConfig: Option[
      zio.aws.comprehend.model.DocumentClassifierOutputDataConfig
    ] = None,
    classifierMetadata: Option[zio.aws.comprehend.model.ClassifierMetadata] =
      None,
    dataAccessRoleArn: Option[IamRoleArn] = None,
    volumeKmsKeyId: Option[KmsKeyId] = None,
    vpcConfig: Option[zio.aws.comprehend.model.VpcConfig] = None,
    mode: Option[zio.aws.comprehend.model.DocumentClassifierMode] = None,
    modelKmsKeyId: Option[KmsKeyId] = None,
    versionName: Option[VersionName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentClassifierProperties = {
    import DocumentClassifierProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierProperties
      .builder()
      .optionallyWith(
        documentClassifierArn.map(value =>
          DocumentClassifierArn.unwrap(value): java.lang.String
        )
      )(_.documentClassifierArn)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        message.map(value => AnyLengthString.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        submitTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        trainingStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingStartTime)
      .optionallyWith(
        trainingEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingEndTime)
      .optionallyWith(inputDataConfig.map(value => value.buildAwsValue()))(
        _.inputDataConfig
      )
      .optionallyWith(outputDataConfig.map(value => value.buildAwsValue()))(
        _.outputDataConfig
      )
      .optionallyWith(classifierMetadata.map(value => value.buildAwsValue()))(
        _.classifierMetadata
      )
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        modelKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.modelKmsKeyId)
      .optionallyWith(
        versionName.map(value => VersionName.unwrap(value): java.lang.String)
      )(_.versionName)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly =
    zio.aws.comprehend.model.DocumentClassifierProperties.wrap(buildAwsValue())
}
object DocumentClassifierProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentClassifierProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DocumentClassifierProperties =
      zio.aws.comprehend.model.DocumentClassifierProperties(
        documentClassifierArn.map(value => value),
        languageCode.map(value => value),
        status.map(value => value),
        message.map(value => value),
        submitTime.map(value => value),
        endTime.map(value => value),
        trainingStartTime.map(value => value),
        trainingEndTime.map(value => value),
        inputDataConfig.map(value => value.asEditable),
        outputDataConfig.map(value => value.asEditable),
        classifierMetadata.map(value => value.asEditable),
        dataAccessRoleArn.map(value => value),
        volumeKmsKeyId.map(value => value),
        vpcConfig.map(value => value.asEditable),
        mode.map(value => value),
        modelKmsKeyId.map(value => value),
        versionName.map(value => value)
      )
    def documentClassifierArn: Option[DocumentClassifierArn]
    def languageCode: Option[zio.aws.comprehend.model.LanguageCode]
    def status: Option[zio.aws.comprehend.model.ModelStatus]
    def message: Option[AnyLengthString]
    def submitTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def trainingStartTime: Option[Timestamp]
    def trainingEndTime: Option[Timestamp]
    def inputDataConfig: Option[
      zio.aws.comprehend.model.DocumentClassifierInputDataConfig.ReadOnly
    ]
    def outputDataConfig: Option[
      zio.aws.comprehend.model.DocumentClassifierOutputDataConfig.ReadOnly
    ]
    def classifierMetadata
        : Option[zio.aws.comprehend.model.ClassifierMetadata.ReadOnly]
    def dataAccessRoleArn: Option[IamRoleArn]
    def volumeKmsKeyId: Option[KmsKeyId]
    def vpcConfig: Option[zio.aws.comprehend.model.VpcConfig.ReadOnly]
    def mode: Option[zio.aws.comprehend.model.DocumentClassifierMode]
    def modelKmsKeyId: Option[KmsKeyId]
    def versionName: Option[VersionName]
    def getDocumentClassifierArn: ZIO[Any, AwsError, DocumentClassifierArn] =
      AwsError.unwrapOptionField("documentClassifierArn", documentClassifierArn)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.comprehend.model.LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, AnyLengthString] =
      AwsError.unwrapOptionField("message", message)
    def getSubmitTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTime", submitTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getTrainingStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingStartTime", trainingStartTime)
    def getTrainingEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingEndTime", trainingEndTime)
    def getInputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentClassifierInputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentClassifierOutputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outputDataConfig", outputDataConfig)
    def getClassifierMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.ClassifierMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("classifierMetadata", classifierMetadata)
    def getDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.comprehend.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getMode
        : ZIO[Any, AwsError, zio.aws.comprehend.model.DocumentClassifierMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getModelKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("modelKmsKeyId", modelKmsKeyId)
    def getVersionName: ZIO[Any, AwsError, VersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierProperties
  ) extends zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly {
    override val documentClassifierArn: Option[DocumentClassifierArn] = scala
      .Option(impl.documentClassifierArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.DocumentClassifierArn(value)
      )
    override val languageCode: Option[zio.aws.comprehend.model.LanguageCode] =
      scala
        .Option(impl.languageCode())
        .map(value => zio.aws.comprehend.model.LanguageCode.wrap(value))
    override val status: Option[zio.aws.comprehend.model.ModelStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.comprehend.model.ModelStatus.wrap(value))
    override val message: Option[AnyLengthString] = scala
      .Option(impl.message())
      .map(value => zio.aws.comprehend.model.primitives.AnyLengthString(value))
    override val submitTime: Option[Timestamp] = scala
      .Option(impl.submitTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val trainingStartTime: Option[Timestamp] = scala
      .Option(impl.trainingStartTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val trainingEndTime: Option[Timestamp] = scala
      .Option(impl.trainingEndTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val inputDataConfig: Option[
      zio.aws.comprehend.model.DocumentClassifierInputDataConfig.ReadOnly
    ] = scala
      .Option(impl.inputDataConfig())
      .map(value =>
        zio.aws.comprehend.model.DocumentClassifierInputDataConfig.wrap(value)
      )
    override val outputDataConfig: Option[
      zio.aws.comprehend.model.DocumentClassifierOutputDataConfig.ReadOnly
    ] = scala
      .Option(impl.outputDataConfig())
      .map(value =>
        zio.aws.comprehend.model.DocumentClassifierOutputDataConfig.wrap(value)
      )
    override val classifierMetadata
        : Option[zio.aws.comprehend.model.ClassifierMetadata.ReadOnly] = scala
      .Option(impl.classifierMetadata())
      .map(value => zio.aws.comprehend.model.ClassifierMetadata.wrap(value))
    override val dataAccessRoleArn: Option[IamRoleArn] = scala
      .Option(impl.dataAccessRoleArn())
      .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
    override val volumeKmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.volumeKmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
    override val vpcConfig
        : Option[zio.aws.comprehend.model.VpcConfig.ReadOnly] = scala
      .Option(impl.vpcConfig())
      .map(value => zio.aws.comprehend.model.VpcConfig.wrap(value))
    override val mode: Option[zio.aws.comprehend.model.DocumentClassifierMode] =
      scala
        .Option(impl.mode())
        .map(value =>
          zio.aws.comprehend.model.DocumentClassifierMode.wrap(value)
        )
    override val modelKmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.modelKmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
    override val versionName: Option[VersionName] = scala
      .Option(impl.versionName())
      .map(value => zio.aws.comprehend.model.primitives.VersionName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassifierProperties
  ): zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly =
    new Wrapper(impl)
}
