package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSentimentDetectionJobResponse(
    sentimentDetectionJobProperties: Option[
      zio.aws.comprehend.model.SentimentDetectionJobProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobResponse = {
    import DescribeSentimentDetectionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobResponse
      .builder()
      .optionallyWith(
        sentimentDetectionJobProperties.map(value => value.buildAwsValue())
      )(_.sentimentDetectionJobProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeSentimentDetectionJobResponse.ReadOnly =
    zio.aws.comprehend.model.DescribeSentimentDetectionJobResponse
      .wrap(buildAwsValue())
}
object DescribeSentimentDetectionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DescribeSentimentDetectionJobResponse =
      zio.aws.comprehend.model.DescribeSentimentDetectionJobResponse(
        sentimentDetectionJobProperties.map(value => value.asEditable)
      )
    def sentimentDetectionJobProperties: Option[
      zio.aws.comprehend.model.SentimentDetectionJobProperties.ReadOnly
    ]
    def getSentimentDetectionJobProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.SentimentDetectionJobProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sentimentDetectionJobProperties",
      sentimentDetectionJobProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobResponse
  ) extends zio.aws.comprehend.model.DescribeSentimentDetectionJobResponse.ReadOnly {
    override val sentimentDetectionJobProperties: Option[
      zio.aws.comprehend.model.SentimentDetectionJobProperties.ReadOnly
    ] = scala
      .Option(impl.sentimentDetectionJobProperties())
      .map(value =>
        zio.aws.comprehend.model.SentimentDetectionJobProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobResponse
  ): zio.aws.comprehend.model.DescribeSentimentDetectionJobResponse.ReadOnly =
    new Wrapper(impl)
}
