package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{Integer, AnyLengthString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EntityRecognizerMetadataEntityTypesListItem(
    `type`: Option[AnyLengthString] = None,
    evaluationMetrics: Option[
      zio.aws.comprehend.model.EntityTypesEvaluationMetrics
    ] = None,
    numberOfTrainMentions: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadataEntityTypesListItem = {
    import EntityRecognizerMetadataEntityTypesListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadataEntityTypesListItem
      .builder()
      .optionallyWith(
        `type`.map(value => AnyLengthString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(evaluationMetrics.map(value => value.buildAwsValue()))(
        _.evaluationMetrics
      )
      .optionallyWith(
        numberOfTrainMentions.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.numberOfTrainMentions)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem.ReadOnly =
    zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem
      .wrap(buildAwsValue())
}
object EntityRecognizerMetadataEntityTypesListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadataEntityTypesListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem =
      zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem(
        `type`.map(value => value),
        evaluationMetrics.map(value => value.asEditable),
        numberOfTrainMentions.map(value => value)
      )
    def `type`: Option[AnyLengthString]
    def evaluationMetrics
        : Option[zio.aws.comprehend.model.EntityTypesEvaluationMetrics.ReadOnly]
    def numberOfTrainMentions: Option[Integer]
    def getType: ZIO[Any, AwsError, AnyLengthString] =
      AwsError.unwrapOptionField("type", `type`)
    def getEvaluationMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityTypesEvaluationMetrics.ReadOnly
    ] = AwsError.unwrapOptionField("evaluationMetrics", evaluationMetrics)
    def getNumberOfTrainMentions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfTrainMentions", numberOfTrainMentions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadataEntityTypesListItem
  ) extends zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem.ReadOnly {
    override val `type`: Option[AnyLengthString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.comprehend.model.primitives.AnyLengthString(value))
    override val evaluationMetrics: Option[
      zio.aws.comprehend.model.EntityTypesEvaluationMetrics.ReadOnly
    ] = scala
      .Option(impl.evaluationMetrics())
      .map(value =>
        zio.aws.comprehend.model.EntityTypesEvaluationMetrics.wrap(value)
      )
    override val numberOfTrainMentions: Option[Integer] = scala
      .Option(impl.numberOfTrainMentions())
      .map(value => zio.aws.comprehend.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadataEntityTypesListItem
  ): zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem.ReadOnly =
    new Wrapper(impl)
}
