package zio.aws.comprehend.model
import java.lang.Integer
import zio.aws.comprehend.model.primitives.MaxResultsInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListSentimentDetectionJobsRequest(
    filter: Option[zio.aws.comprehend.model.SentimentDetectionJobFilter] = None,
    nextToken: Option[String] = None,
    maxResults: Option[MaxResultsInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest = {
    import ListSentimentDetectionJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResultsInteger.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListSentimentDetectionJobsRequest.ReadOnly =
    zio.aws.comprehend.model.ListSentimentDetectionJobsRequest
      .wrap(buildAwsValue())
}
object ListSentimentDetectionJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ListSentimentDetectionJobsRequest =
      zio.aws.comprehend.model.ListSentimentDetectionJobsRequest(
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filter
        : Option[zio.aws.comprehend.model.SentimentDetectionJobFilter.ReadOnly]
    def nextToken: Option[String]
    def maxResults: Option[MaxResultsInteger]
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.SentimentDetectionJobFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest
  ) extends zio.aws.comprehend.model.ListSentimentDetectionJobsRequest.ReadOnly {
    override val filter: Option[
      zio.aws.comprehend.model.SentimentDetectionJobFilter.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        zio.aws.comprehend.model.SentimentDetectionJobFilter.wrap(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[MaxResultsInteger] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.comprehend.model.primitives.MaxResultsInteger(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest
  ): zio.aws.comprehend.model.ListSentimentDetectionJobsRequest.ReadOnly =
    new Wrapper(impl)
}
