package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.IdentityPoolId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BulkPublishRequest(identityPoolId: IdentityPoolId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.BulkPublishRequest = {
    import BulkPublishRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.BulkPublishRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.BulkPublishRequest.ReadOnly =
    zio.aws.cognitosync.model.BulkPublishRequest.wrap(buildAwsValue())
}
object BulkPublishRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.BulkPublishRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.BulkPublishRequest =
      zio.aws.cognitosync.model.BulkPublishRequest(identityPoolId)
    def identityPoolId: IdentityPoolId
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.BulkPublishRequest
  ) extends zio.aws.cognitosync.model.BulkPublishRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitosync.model.primitives.IdentityPoolId(impl.identityPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.BulkPublishRequest
  ): zio.aws.cognitosync.model.BulkPublishRequest.ReadOnly = new Wrapper(impl)
}
