package zio.aws.cognitosync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cognitosync.model.primitives.{Date, IdentityPoolId}
import scala.jdk.CollectionConverters._
final case class GetBulkPublishDetailsResponse(
    identityPoolId: Optional[IdentityPoolId] = Optional.Absent,
    bulkPublishStartTime: Optional[Date] = Optional.Absent,
    bulkPublishCompleteTime: Optional[Date] = Optional.Absent,
    bulkPublishStatus: Optional[zio.aws.cognitosync.model.BulkPublishStatus] =
      Optional.Absent,
    failureMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsResponse = {
    import GetBulkPublishDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsResponse
      .builder()
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .optionallyWith(
        bulkPublishStartTime.map(value => Date.unwrap(value): Instant)
      )(_.bulkPublishStartTime)
      .optionallyWith(
        bulkPublishCompleteTime.map(value => Date.unwrap(value): Instant)
      )(_.bulkPublishCompleteTime)
      .optionallyWith(bulkPublishStatus.map(value => value.unwrap))(
        _.bulkPublishStatus
      )
      .optionallyWith(failureMessage.map(value => value: java.lang.String))(
        _.failureMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitosync.model.GetBulkPublishDetailsResponse.ReadOnly =
    zio.aws.cognitosync.model.GetBulkPublishDetailsResponse
      .wrap(buildAwsValue())
}
object GetBulkPublishDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.GetBulkPublishDetailsResponse =
      zio.aws.cognitosync.model.GetBulkPublishDetailsResponse(
        identityPoolId.map(value => value),
        bulkPublishStartTime.map(value => value),
        bulkPublishCompleteTime.map(value => value),
        bulkPublishStatus.map(value => value),
        failureMessage.map(value => value)
      )
    def identityPoolId: Optional[IdentityPoolId]
    def bulkPublishStartTime: Optional[Date]
    def bulkPublishCompleteTime: Optional[Date]
    def bulkPublishStatus: Optional[zio.aws.cognitosync.model.BulkPublishStatus]
    def failureMessage: Optional[String]
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getBulkPublishStartTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("bulkPublishStartTime", bulkPublishStartTime)
    def getBulkPublishCompleteTime: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("bulkPublishCompleteTime", bulkPublishCompleteTime)
    def getBulkPublishStatus
        : ZIO[Any, AwsError, zio.aws.cognitosync.model.BulkPublishStatus] =
      AwsError.unwrapOptionField("bulkPublishStatus", bulkPublishStatus)
    def getFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsResponse
  ) extends zio.aws.cognitosync.model.GetBulkPublishDetailsResponse.ReadOnly {
    override val identityPoolId: Optional[IdentityPoolId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityPoolId())
        .map(value =>
          zio.aws.cognitosync.model.primitives.IdentityPoolId(value)
        )
    override val bulkPublishStartTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.bulkPublishStartTime())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
    override val bulkPublishCompleteTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.bulkPublishCompleteTime())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
    override val bulkPublishStatus
        : Optional[zio.aws.cognitosync.model.BulkPublishStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bulkPublishStatus())
        .map(value => zio.aws.cognitosync.model.BulkPublishStatus.wrap(value))
    override val failureMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsResponse
  ): zio.aws.cognitosync.model.GetBulkPublishDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
