package zio.aws.cognitosync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeIdentityUsageResponse(
    identityUsage: Optional[zio.aws.cognitosync.model.IdentityUsage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageResponse = {
    import DescribeIdentityUsageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageResponse
      .builder()
      .optionallyWith(identityUsage.map(value => value.buildAwsValue()))(
        _.identityUsage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitosync.model.DescribeIdentityUsageResponse.ReadOnly =
    zio.aws.cognitosync.model.DescribeIdentityUsageResponse
      .wrap(buildAwsValue())
}
object DescribeIdentityUsageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.DescribeIdentityUsageResponse =
      zio.aws.cognitosync.model.DescribeIdentityUsageResponse(
        identityUsage.map(value => value.asEditable)
      )
    def identityUsage
        : Optional[zio.aws.cognitosync.model.IdentityUsage.ReadOnly]
    def getIdentityUsage
        : ZIO[Any, AwsError, zio.aws.cognitosync.model.IdentityUsage.ReadOnly] =
      AwsError.unwrapOptionField("identityUsage", identityUsage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageResponse
  ) extends zio.aws.cognitosync.model.DescribeIdentityUsageResponse.ReadOnly {
    override val identityUsage
        : Optional[zio.aws.cognitosync.model.IdentityUsage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityUsage())
        .map(value => zio.aws.cognitosync.model.IdentityUsage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageResponse
  ): zio.aws.cognitosync.model.DescribeIdentityUsageResponse.ReadOnly =
    new Wrapper(impl)
}
