package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.IdentityPoolId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetIdentityPoolConfigurationRequest(
    identityPoolId: IdentityPoolId,
    pushSync: Optional[zio.aws.cognitosync.model.PushSync] = Optional.Absent,
    cognitoStreams: Optional[zio.aws.cognitosync.model.CognitoStreams] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationRequest = {
    import SetIdentityPoolConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .optionallyWith(pushSync.map(value => value.buildAwsValue()))(_.pushSync)
      .optionallyWith(cognitoStreams.map(value => value.buildAwsValue()))(
        _.cognitoStreams
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitosync.model.SetIdentityPoolConfigurationRequest.ReadOnly =
    zio.aws.cognitosync.model.SetIdentityPoolConfigurationRequest
      .wrap(buildAwsValue())
}
object SetIdentityPoolConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitosync.model.SetIdentityPoolConfigurationRequest =
      zio.aws.cognitosync.model.SetIdentityPoolConfigurationRequest(
        identityPoolId,
        pushSync.map(value => value.asEditable),
        cognitoStreams.map(value => value.asEditable)
      )
    def identityPoolId: IdentityPoolId
    def pushSync: Optional[zio.aws.cognitosync.model.PushSync.ReadOnly]
    def cognitoStreams
        : Optional[zio.aws.cognitosync.model.CognitoStreams.ReadOnly]
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getPushSync
        : ZIO[Any, AwsError, zio.aws.cognitosync.model.PushSync.ReadOnly] =
      AwsError.unwrapOptionField("pushSync", pushSync)
    def getCognitoStreams: ZIO[
      Any,
      AwsError,
      zio.aws.cognitosync.model.CognitoStreams.ReadOnly
    ] = AwsError.unwrapOptionField("cognitoStreams", cognitoStreams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationRequest
  ) extends zio.aws.cognitosync.model.SetIdentityPoolConfigurationRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitosync.model.primitives.IdentityPoolId(impl.identityPoolId())
    override val pushSync
        : Optional[zio.aws.cognitosync.model.PushSync.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pushSync())
        .map(value => zio.aws.cognitosync.model.PushSync.wrap(value))
    override val cognitoStreams
        : Optional[zio.aws.cognitosync.model.CognitoStreams.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cognitoStreams())
        .map(value => zio.aws.cognitosync.model.CognitoStreams.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationRequest
  ): zio.aws.cognitosync.model.SetIdentityPoolConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
