package zio.aws.cognitosync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cognitosync.model.primitives.{
  IntegerString,
  IdentityId,
  IdentityPoolId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDatasetsRequest(
    identityPoolId: IdentityPoolId,
    identityId: IdentityId,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[IntegerString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.ListDatasetsRequest = {
    import ListDatasetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.ListDatasetsRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .identityId(IdentityId.unwrap(identityId): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => IntegerString.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.ListDatasetsRequest.ReadOnly =
    zio.aws.cognitosync.model.ListDatasetsRequest.wrap(buildAwsValue())
}
object ListDatasetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.ListDatasetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.ListDatasetsRequest =
      zio.aws.cognitosync.model.ListDatasetsRequest(
        identityPoolId,
        identityId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def identityPoolId: IdentityPoolId
    def identityId: IdentityId
    def nextToken: Optional[String]
    def maxResults: Optional[IntegerString]
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getIdentityId: ZIO[Any, Nothing, IdentityId] = ZIO.succeed(identityId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, IntegerString] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.ListDatasetsRequest
  ) extends zio.aws.cognitosync.model.ListDatasetsRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitosync.model.primitives.IdentityPoolId(impl.identityPoolId())
    override val identityId: IdentityId =
      zio.aws.cognitosync.model.primitives.IdentityId(impl.identityId())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[IntegerString] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.cognitosync.model.primitives.IntegerString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.ListDatasetsRequest
  ): zio.aws.cognitosync.model.ListDatasetsRequest.ReadOnly = new Wrapper(impl)
}
