package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.IdentityPoolId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeIdentityPoolUsageRequest(
    identityPoolId: IdentityPoolId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageRequest = {
    import DescribeIdentityPoolUsageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitosync.model.DescribeIdentityPoolUsageRequest.ReadOnly =
    zio.aws.cognitosync.model.DescribeIdentityPoolUsageRequest
      .wrap(buildAwsValue())
}
object DescribeIdentityPoolUsageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.DescribeIdentityPoolUsageRequest =
      zio.aws.cognitosync.model.DescribeIdentityPoolUsageRequest(identityPoolId)
    def identityPoolId: IdentityPoolId
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageRequest
  ) extends zio.aws.cognitosync.model.DescribeIdentityPoolUsageRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitosync.model.primitives.IdentityPoolId(impl.identityPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageRequest
  ): zio.aws.cognitosync.model.DescribeIdentityPoolUsageRequest.ReadOnly =
    new Wrapper(impl)
}
