package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.{
  PushToken,
  IdentityId,
  IdentityPoolId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RegisterDeviceRequest(
    identityPoolId: IdentityPoolId,
    identityId: IdentityId,
    platform: zio.aws.cognitosync.model.Platform,
    token: PushToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.RegisterDeviceRequest = {
    import RegisterDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.RegisterDeviceRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .identityId(IdentityId.unwrap(identityId): java.lang.String)
      .platform(platform.unwrap)
      .token(PushToken.unwrap(token): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.RegisterDeviceRequest.ReadOnly =
    zio.aws.cognitosync.model.RegisterDeviceRequest.wrap(buildAwsValue())
}
object RegisterDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.RegisterDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.RegisterDeviceRequest =
      zio.aws.cognitosync.model.RegisterDeviceRequest(
        identityPoolId,
        identityId,
        platform,
        token
      )
    def identityPoolId: IdentityPoolId
    def identityId: IdentityId
    def platform: zio.aws.cognitosync.model.Platform
    def token: PushToken
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getIdentityId: ZIO[Any, Nothing, IdentityId] = ZIO.succeed(identityId)
    def getPlatform: ZIO[Any, Nothing, zio.aws.cognitosync.model.Platform] =
      ZIO.succeed(platform)
    def getToken: ZIO[Any, Nothing, PushToken] = ZIO.succeed(token)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.RegisterDeviceRequest
  ) extends zio.aws.cognitosync.model.RegisterDeviceRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitosync.model.primitives.IdentityPoolId(impl.identityPoolId())
    override val identityId: IdentityId =
      zio.aws.cognitosync.model.primitives.IdentityId(impl.identityId())
    override val platform: zio.aws.cognitosync.model.Platform =
      zio.aws.cognitosync.model.Platform.wrap(impl.platform())
    override val token: PushToken =
      zio.aws.cognitosync.model.primitives.PushToken(impl.token())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.RegisterDeviceRequest
  ): zio.aws.cognitosync.model.RegisterDeviceRequest.ReadOnly = new Wrapper(
    impl
  )
}
