package zio.aws.cognitosync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cognitosync.model.primitives.{Date, RecordValue, RecordKey}
import scala.jdk.CollectionConverters._
final case class Record(
    key: Optional[RecordKey] = Optional.Absent,
    value: Optional[RecordValue] = Optional.Absent,
    syncCount: Optional[Long] = Optional.Absent,
    lastModifiedDate: Optional[Date] = Optional.Absent,
    lastModifiedBy: Optional[String] = Optional.Absent,
    deviceLastModifiedDate: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.Record = {
    import Record.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.Record
      .builder()
      .optionallyWith(
        key.map(value => RecordKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => RecordValue.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(syncCount.map(value => value: java.lang.Long))(
        _.syncCount
      )
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(lastModifiedBy.map(value => value: java.lang.String))(
        _.lastModifiedBy
      )
      .optionallyWith(
        deviceLastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.deviceLastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.Record.ReadOnly =
    zio.aws.cognitosync.model.Record.wrap(buildAwsValue())
}
object Record {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.Record
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.Record =
      zio.aws.cognitosync.model.Record(
        key.map(value => value),
        value.map(value => value),
        syncCount.map(value => value),
        lastModifiedDate.map(value => value),
        lastModifiedBy.map(value => value),
        deviceLastModifiedDate.map(value => value)
      )
    def key: Optional[RecordKey]
    def value: Optional[RecordValue]
    def syncCount: Optional[Long]
    def lastModifiedDate: Optional[Date]
    def lastModifiedBy: Optional[String]
    def deviceLastModifiedDate: Optional[Date]
    def getKey: ZIO[Any, AwsError, RecordKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, RecordValue] =
      AwsError.unwrapOptionField("value", value)
    def getSyncCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("syncCount", syncCount)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLastModifiedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getDeviceLastModifiedDate: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("deviceLastModifiedDate", deviceLastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.Record
  ) extends zio.aws.cognitosync.model.Record.ReadOnly {
    override val key: Optional[RecordKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.cognitosync.model.primitives.RecordKey(value))
    override val value: Optional[RecordValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.cognitosync.model.primitives.RecordValue(value))
    override val syncCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.syncCount())
      .map(value => value: Long)
    override val lastModifiedDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
    override val lastModifiedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedBy())
      .map(value => value: String)
    override val deviceLastModifiedDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceLastModifiedDate())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.Record
  ): zio.aws.cognitosync.model.Record.ReadOnly = new Wrapper(impl)
}
