package zio.aws.cognitosync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cognitosync.model.primitives.{Date, IdentityPoolId}
import scala.jdk.CollectionConverters._
final case class IdentityPoolUsage(
    identityPoolId: Optional[IdentityPoolId] = Optional.Absent,
    syncSessionsCount: Optional[Long] = Optional.Absent,
    dataStorage: Optional[Long] = Optional.Absent,
    lastModifiedDate: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage = {
    import IdentityPoolUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage
      .builder()
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .optionallyWith(syncSessionsCount.map(value => value: java.lang.Long))(
        _.syncSessionsCount
      )
      .optionallyWith(dataStorage.map(value => value: java.lang.Long))(
        _.dataStorage
      )
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly =
    zio.aws.cognitosync.model.IdentityPoolUsage.wrap(buildAwsValue())
}
object IdentityPoolUsage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.IdentityPoolUsage =
      zio.aws.cognitosync.model.IdentityPoolUsage(
        identityPoolId.map(value => value),
        syncSessionsCount.map(value => value),
        dataStorage.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def identityPoolId: Optional[IdentityPoolId]
    def syncSessionsCount: Optional[Long]
    def dataStorage: Optional[Long]
    def lastModifiedDate: Optional[Date]
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getSyncSessionsCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("syncSessionsCount", syncSessionsCount)
    def getDataStorage: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("dataStorage", dataStorage)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage
  ) extends zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly {
    override val identityPoolId: Optional[IdentityPoolId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityPoolId())
        .map(value =>
          zio.aws.cognitosync.model.primitives.IdentityPoolId(value)
        )
    override val syncSessionsCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.syncSessionsCount())
      .map(value => value: Long)
    override val dataStorage: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.dataStorage())
      .map(value => value: Long)
    override val lastModifiedDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage
  ): zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly = new Wrapper(impl)
}
