package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.{IdentityId, IdentityPoolId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeIdentityUsageRequest(
    identityPoolId: IdentityPoolId,
    identityId: IdentityId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageRequest = {
    import DescribeIdentityUsageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .identityId(IdentityId.unwrap(identityId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitosync.model.DescribeIdentityUsageRequest.ReadOnly =
    zio.aws.cognitosync.model.DescribeIdentityUsageRequest.wrap(buildAwsValue())
}
object DescribeIdentityUsageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.DescribeIdentityUsageRequest =
      zio.aws.cognitosync.model
        .DescribeIdentityUsageRequest(identityPoolId, identityId)
    def identityPoolId: IdentityPoolId
    def identityId: IdentityId
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getIdentityId: ZIO[Any, Nothing, IdentityId] = ZIO.succeed(identityId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageRequest
  ) extends zio.aws.cognitosync.model.DescribeIdentityUsageRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitosync.model.primitives.IdentityPoolId(impl.identityPoolId())
    override val identityId: IdentityId =
      zio.aws.cognitosync.model.primitives.IdentityId(impl.identityId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageRequest
  ): zio.aws.cognitosync.model.DescribeIdentityUsageRequest.ReadOnly =
    new Wrapper(impl)
}
