package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDatasetsResponse(
    datasets: Optional[Iterable[zio.aws.cognitosync.model.Dataset]] =
      Optional.Absent,
    count: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.ListDatasetsResponse = {
    import ListDatasetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.ListDatasetsResponse
      .builder()
      .optionallyWith(
        datasets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datasets)
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.ListDatasetsResponse.ReadOnly =
    zio.aws.cognitosync.model.ListDatasetsResponse.wrap(buildAwsValue())
}
object ListDatasetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.ListDatasetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.ListDatasetsResponse =
      zio.aws.cognitosync.model.ListDatasetsResponse(
        datasets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        count.map(value => value),
        nextToken.map(value => value)
      )
    def datasets: Optional[List[zio.aws.cognitosync.model.Dataset.ReadOnly]]
    def count: Optional[Integer]
    def nextToken: Optional[String]
    def getDatasets
        : ZIO[Any, AwsError, List[zio.aws.cognitosync.model.Dataset.ReadOnly]] =
      AwsError.unwrapOptionField("datasets", datasets)
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.ListDatasetsResponse
  ) extends zio.aws.cognitosync.model.ListDatasetsResponse.ReadOnly {
    override val datasets
        : Optional[List[zio.aws.cognitosync.model.Dataset.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitosync.model.Dataset.wrap(item)
          }.toList
        )
    override val count: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.ListDatasetsResponse
  ): zio.aws.cognitosync.model.ListDatasetsResponse.ReadOnly = new Wrapper(impl)
}
