package zio.aws.cognitosync.model
import scala.jdk.CollectionConverters._
sealed trait Platform {
  def unwrap: software.amazon.awssdk.services.cognitosync.model.Platform
}
object Platform {
  def wrap(
      value: software.amazon.awssdk.services.cognitosync.model.Platform
  ): zio.aws.cognitosync.model.Platform = value match {
    case software.amazon.awssdk.services.cognitosync.model.Platform.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitosync.model.Platform.APNS =>
      val r = APNS
      r
    case software.amazon.awssdk.services.cognitosync.model.Platform.APNS_SANDBOX =>
      val r = APNS_SANDBOX
      r
    case software.amazon.awssdk.services.cognitosync.model.Platform.GCM =>
      val r = GCM
      r
    case software.amazon.awssdk.services.cognitosync.model.Platform.ADM =>
      val r = ADM
      r
  }
  case object unknownToSdkVersion extends zio.aws.cognitosync.model.Platform {
    override def unwrap
        : software.amazon.awssdk.services.cognitosync.model.Platform =
      software.amazon.awssdk.services.cognitosync.model.Platform.UNKNOWN_TO_SDK_VERSION
  }
  case object APNS extends zio.aws.cognitosync.model.Platform {
    override def unwrap
        : software.amazon.awssdk.services.cognitosync.model.Platform =
      software.amazon.awssdk.services.cognitosync.model.Platform.APNS
  }
  case object APNS_SANDBOX extends zio.aws.cognitosync.model.Platform {
    override def unwrap
        : software.amazon.awssdk.services.cognitosync.model.Platform =
      software.amazon.awssdk.services.cognitosync.model.Platform.APNS_SANDBOX
  }
  case object GCM extends zio.aws.cognitosync.model.Platform {
    override def unwrap
        : software.amazon.awssdk.services.cognitosync.model.Platform =
      software.amazon.awssdk.services.cognitosync.model.Platform.GCM
  }
  case object ADM extends zio.aws.cognitosync.model.Platform {
    override def unwrap
        : software.amazon.awssdk.services.cognitosync.model.Platform =
      software.amazon.awssdk.services.cognitosync.model.Platform.ADM
  }
}
