package zio.aws.cognitosync.model
import scala.jdk.CollectionConverters._
sealed trait BulkPublishStatus {
  def unwrap
      : software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus
}
object BulkPublishStatus {
  def wrap(
      value: software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus
  ): zio.aws.cognitosync.model.BulkPublishStatus = value match {
    case software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus.NOT_STARTED =>
      val r = NOT_STARTED
      r
    case software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitosync.model.BulkPublishStatus {
    override def unwrap
        : software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus =
      software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_STARTED extends zio.aws.cognitosync.model.BulkPublishStatus {
    override def unwrap
        : software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus =
      software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus.NOT_STARTED
  }
  case object IN_PROGRESS extends zio.aws.cognitosync.model.BulkPublishStatus {
    override def unwrap
        : software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus =
      software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus.IN_PROGRESS
  }
  case object FAILED extends zio.aws.cognitosync.model.BulkPublishStatus {
    override def unwrap
        : software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus =
      software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus.FAILED
  }
  case object SUCCEEDED extends zio.aws.cognitosync.model.BulkPublishStatus {
    override def unwrap
        : software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus =
      software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus.SUCCEEDED
  }
}
