package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.{
  DeviceId,
  DatasetName,
  IdentityId,
  IdentityPoolId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SubscribeToDatasetRequest(
    identityPoolId: IdentityPoolId,
    identityId: IdentityId,
    datasetName: DatasetName,
    deviceId: DeviceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.SubscribeToDatasetRequest = {
    import SubscribeToDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.SubscribeToDatasetRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .identityId(IdentityId.unwrap(identityId): java.lang.String)
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .deviceId(DeviceId.unwrap(deviceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.SubscribeToDatasetRequest.ReadOnly =
    zio.aws.cognitosync.model.SubscribeToDatasetRequest.wrap(buildAwsValue())
}
object SubscribeToDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.SubscribeToDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.SubscribeToDatasetRequest =
      zio.aws.cognitosync.model.SubscribeToDatasetRequest(
        identityPoolId,
        identityId,
        datasetName,
        deviceId
      )
    def identityPoolId: IdentityPoolId
    def identityId: IdentityId
    def datasetName: DatasetName
    def deviceId: DeviceId
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getIdentityId: ZIO[Any, Nothing, IdentityId] = ZIO.succeed(identityId)
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
    def getDeviceId: ZIO[Any, Nothing, DeviceId] = ZIO.succeed(deviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.SubscribeToDatasetRequest
  ) extends zio.aws.cognitosync.model.SubscribeToDatasetRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitosync.model.primitives.IdentityPoolId(impl.identityPoolId())
    override val identityId: IdentityId =
      zio.aws.cognitosync.model.primitives.IdentityId(impl.identityId())
    override val datasetName: DatasetName =
      zio.aws.cognitosync.model.primitives.DatasetName(impl.datasetName())
    override val deviceId: DeviceId =
      zio.aws.cognitosync.model.primitives.DeviceId(impl.deviceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.SubscribeToDatasetRequest
  ): zio.aws.cognitosync.model.SubscribeToDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
