package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.IdentityPoolId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetIdentityPoolConfigurationResponse(
    identityPoolId: Optional[IdentityPoolId] = Optional.Absent,
    pushSync: Optional[zio.aws.cognitosync.model.PushSync] = Optional.Absent,
    cognitoStreams: Optional[zio.aws.cognitosync.model.CognitoStreams] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationResponse = {
    import GetIdentityPoolConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationResponse
      .builder()
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .optionallyWith(pushSync.map(value => value.buildAwsValue()))(_.pushSync)
      .optionallyWith(cognitoStreams.map(value => value.buildAwsValue()))(
        _.cognitoStreams
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse.ReadOnly =
    zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse
      .wrap(buildAwsValue())
}
object GetIdentityPoolConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse =
      zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse(
        identityPoolId.map(value => value),
        pushSync.map(value => value.asEditable),
        cognitoStreams.map(value => value.asEditable)
      )
    def identityPoolId: Optional[IdentityPoolId]
    def pushSync: Optional[zio.aws.cognitosync.model.PushSync.ReadOnly]
    def cognitoStreams
        : Optional[zio.aws.cognitosync.model.CognitoStreams.ReadOnly]
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getPushSync
        : ZIO[Any, AwsError, zio.aws.cognitosync.model.PushSync.ReadOnly] =
      AwsError.unwrapOptionField("pushSync", pushSync)
    def getCognitoStreams: ZIO[
      Any,
      AwsError,
      zio.aws.cognitosync.model.CognitoStreams.ReadOnly
    ] = AwsError.unwrapOptionField("cognitoStreams", cognitoStreams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationResponse
  ) extends zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse.ReadOnly {
    override val identityPoolId: Optional[IdentityPoolId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityPoolId())
        .map(value =>
          zio.aws.cognitosync.model.primitives.IdentityPoolId(value)
        )
    override val pushSync
        : Optional[zio.aws.cognitosync.model.PushSync.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pushSync())
        .map(value => zio.aws.cognitosync.model.PushSync.wrap(value))
    override val cognitoStreams
        : Optional[zio.aws.cognitosync.model.CognitoStreams.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cognitoStreams())
        .map(value => zio.aws.cognitosync.model.CognitoStreams.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationResponse
  ): zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
