package zio.aws.cognitosync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cognitosync.model.primitives.{
  IntegerString,
  IdentityId,
  IdentityPoolId,
  SyncSessionToken,
  DatasetName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRecordsRequest(
    identityPoolId: IdentityPoolId,
    identityId: IdentityId,
    datasetName: DatasetName,
    lastSyncCount: Optional[Long] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[IntegerString] = Optional.Absent,
    syncSessionToken: Optional[SyncSessionToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest = {
    import ListRecordsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .identityId(IdentityId.unwrap(identityId): java.lang.String)
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .optionallyWith(lastSyncCount.map(value => value: java.lang.Long))(
        _.lastSyncCount
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => IntegerString.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        syncSessionToken.map(value =>
          SyncSessionToken.unwrap(value): java.lang.String
        )
      )(_.syncSessionToken)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.ListRecordsRequest.ReadOnly =
    zio.aws.cognitosync.model.ListRecordsRequest.wrap(buildAwsValue())
}
object ListRecordsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.ListRecordsRequest =
      zio.aws.cognitosync.model.ListRecordsRequest(
        identityPoolId,
        identityId,
        datasetName,
        lastSyncCount.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        syncSessionToken.map(value => value)
      )
    def identityPoolId: IdentityPoolId
    def identityId: IdentityId
    def datasetName: DatasetName
    def lastSyncCount: Optional[Long]
    def nextToken: Optional[String]
    def maxResults: Optional[IntegerString]
    def syncSessionToken: Optional[SyncSessionToken]
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getIdentityId: ZIO[Any, Nothing, IdentityId] = ZIO.succeed(identityId)
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
    def getLastSyncCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("lastSyncCount", lastSyncCount)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, IntegerString] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSyncSessionToken: ZIO[Any, AwsError, SyncSessionToken] =
      AwsError.unwrapOptionField("syncSessionToken", syncSessionToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest
  ) extends zio.aws.cognitosync.model.ListRecordsRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitosync.model.primitives.IdentityPoolId(impl.identityPoolId())
    override val identityId: IdentityId =
      zio.aws.cognitosync.model.primitives.IdentityId(impl.identityId())
    override val datasetName: DatasetName =
      zio.aws.cognitosync.model.primitives.DatasetName(impl.datasetName())
    override val lastSyncCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.lastSyncCount())
      .map(value => value: Long)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[IntegerString] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.cognitosync.model.primitives.IntegerString(value))
    override val syncSessionToken: Optional[SyncSessionToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.syncSessionToken())
        .map(value =>
          zio.aws.cognitosync.model.primitives.SyncSessionToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest
  ): zio.aws.cognitosync.model.ListRecordsRequest.ReadOnly = new Wrapper(impl)
}
