package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.{
  LambdaFunctionArn,
  CognitoEventType,
  IdentityPoolId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetCognitoEventsRequest(
    identityPoolId: IdentityPoolId,
    events: Map[CognitoEventType, LambdaFunctionArn]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.SetCognitoEventsRequest = {
    import SetCognitoEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.SetCognitoEventsRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .events(
        events
          .map({ case (key, value) =>
            (CognitoEventType
              .unwrap(key): java.lang.String) -> (LambdaFunctionArn
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.SetCognitoEventsRequest.ReadOnly =
    zio.aws.cognitosync.model.SetCognitoEventsRequest.wrap(buildAwsValue())
}
object SetCognitoEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.SetCognitoEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.SetCognitoEventsRequest =
      zio.aws.cognitosync.model.SetCognitoEventsRequest(identityPoolId, events)
    def identityPoolId: IdentityPoolId
    def events: Map[CognitoEventType, LambdaFunctionArn]
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getEvents: ZIO[Any, Nothing, Map[CognitoEventType, LambdaFunctionArn]] =
      ZIO.succeed(events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.SetCognitoEventsRequest
  ) extends zio.aws.cognitosync.model.SetCognitoEventsRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitosync.model.primitives.IdentityPoolId(impl.identityPoolId())
    override val events: Map[CognitoEventType, LambdaFunctionArn] = impl
      .events()
      .asScala
      .map({ case (key, value) =>
        zio.aws.cognitosync.model.primitives.CognitoEventType(
          key
        ) -> zio.aws.cognitosync.model.primitives.LambdaFunctionArn(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.SetCognitoEventsRequest
  ): zio.aws.cognitosync.model.SetCognitoEventsRequest.ReadOnly = new Wrapper(
    impl
  )
}
