package zio.aws.cognitosync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cognitosync.model.primitives.IntegerString
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListIdentityPoolUsageRequest(
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[IntegerString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageRequest = {
    import ListIdentityPoolUsageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => IntegerString.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.cognitosync.model.ListIdentityPoolUsageRequest.ReadOnly =
    zio.aws.cognitosync.model.ListIdentityPoolUsageRequest.wrap(buildAwsValue())
}
object ListIdentityPoolUsageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.ListIdentityPoolUsageRequest =
      zio.aws.cognitosync.model.ListIdentityPoolUsageRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[String]
    def maxResults: Optional[IntegerString]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, IntegerString] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageRequest
  ) extends zio.aws.cognitosync.model.ListIdentityPoolUsageRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[IntegerString] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.cognitosync.model.primitives.IntegerString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageRequest
  ): zio.aws.cognitosync.model.ListIdentityPoolUsageRequest.ReadOnly =
    new Wrapper(impl)
}
