package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListRecordsResponse(
    records: Optional[Iterable[zio.aws.cognitosync.model.Record]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    count: Optional[Integer] = Optional.Absent,
    datasetSyncCount: Optional[Long] = Optional.Absent,
    lastModifiedBy: Optional[String] = Optional.Absent,
    mergedDatasetNames: Optional[Iterable[String]] = Optional.Absent,
    datasetExists: Optional[Boolean] = Optional.Absent,
    datasetDeletedAfterRequestedSyncCount: Optional[Boolean] = Optional.Absent,
    syncSessionToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.ListRecordsResponse = {
    import ListRecordsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.ListRecordsResponse
      .builder()
      .optionallyWith(
        records.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.records)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .optionallyWith(datasetSyncCount.map(value => value: java.lang.Long))(
        _.datasetSyncCount
      )
      .optionallyWith(lastModifiedBy.map(value => value: java.lang.String))(
        _.lastModifiedBy
      )
      .optionallyWith(
        mergedDatasetNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.mergedDatasetNames)
      .optionallyWith(datasetExists.map(value => value: java.lang.Boolean))(
        _.datasetExists
      )
      .optionallyWith(
        datasetDeletedAfterRequestedSyncCount.map(value =>
          value: java.lang.Boolean
        )
      )(_.datasetDeletedAfterRequestedSyncCount)
      .optionallyWith(syncSessionToken.map(value => value: java.lang.String))(
        _.syncSessionToken
      )
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.ListRecordsResponse.ReadOnly =
    zio.aws.cognitosync.model.ListRecordsResponse.wrap(buildAwsValue())
}
object ListRecordsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.ListRecordsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.ListRecordsResponse =
      zio.aws.cognitosync.model.ListRecordsResponse(
        records.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        count.map(value => value),
        datasetSyncCount.map(value => value),
        lastModifiedBy.map(value => value),
        mergedDatasetNames.map(value => value),
        datasetExists.map(value => value),
        datasetDeletedAfterRequestedSyncCount.map(value => value),
        syncSessionToken.map(value => value)
      )
    def records: Optional[List[zio.aws.cognitosync.model.Record.ReadOnly]]
    def nextToken: Optional[String]
    def count: Optional[Integer]
    def datasetSyncCount: Optional[Long]
    def lastModifiedBy: Optional[String]
    def mergedDatasetNames: Optional[List[String]]
    def datasetExists: Optional[Boolean]
    def datasetDeletedAfterRequestedSyncCount: Optional[Boolean]
    def syncSessionToken: Optional[String]
    def getRecords
        : ZIO[Any, AwsError, List[zio.aws.cognitosync.model.Record.ReadOnly]] =
      AwsError.unwrapOptionField("records", records)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
    def getDatasetSyncCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("datasetSyncCount", datasetSyncCount)
    def getLastModifiedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getMergedDatasetNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("mergedDatasetNames", mergedDatasetNames)
    def getDatasetExists: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("datasetExists", datasetExists)
    def getDatasetDeletedAfterRequestedSyncCount: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "datasetDeletedAfterRequestedSyncCount",
        datasetDeletedAfterRequestedSyncCount
      )
    def getSyncSessionToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("syncSessionToken", syncSessionToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.ListRecordsResponse
  ) extends zio.aws.cognitosync.model.ListRecordsResponse.ReadOnly {
    override val records
        : Optional[List[zio.aws.cognitosync.model.Record.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.records())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitosync.model.Record.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val count: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: Integer)
    override val datasetSyncCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetSyncCount())
      .map(value => value: Long)
    override val lastModifiedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedBy())
      .map(value => value: String)
    override val mergedDatasetNames: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mergedDatasetNames())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val datasetExists: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetExists())
      .map(value => value: Boolean)
    override val datasetDeletedAfterRequestedSyncCount: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetDeletedAfterRequestedSyncCount())
        .map(value => value: Boolean)
    override val syncSessionToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.syncSessionToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.ListRecordsResponse
  ): zio.aws.cognitosync.model.ListRecordsResponse.ReadOnly = new Wrapper(impl)
}
