package zio.aws.cognitosync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cognitosync.model.primitives.{
  Integer,
  Date,
  IdentityPoolId,
  IdentityId
}
import scala.jdk.CollectionConverters._
final case class IdentityUsage(
    identityId: Optional[IdentityId] = Optional.Absent,
    identityPoolId: Optional[IdentityPoolId] = Optional.Absent,
    lastModifiedDate: Optional[Date] = Optional.Absent,
    datasetCount: Optional[Integer] = Optional.Absent,
    dataStorage: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.IdentityUsage = {
    import IdentityUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.IdentityUsage
      .builder()
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(datasetCount.map(value => value: java.lang.Integer))(
        _.datasetCount
      )
      .optionallyWith(dataStorage.map(value => value: java.lang.Long))(
        _.dataStorage
      )
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.IdentityUsage.ReadOnly =
    zio.aws.cognitosync.model.IdentityUsage.wrap(buildAwsValue())
}
object IdentityUsage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.IdentityUsage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.IdentityUsage =
      zio.aws.cognitosync.model.IdentityUsage(
        identityId.map(value => value),
        identityPoolId.map(value => value),
        lastModifiedDate.map(value => value),
        datasetCount.map(value => value),
        dataStorage.map(value => value)
      )
    def identityId: Optional[IdentityId]
    def identityPoolId: Optional[IdentityPoolId]
    def lastModifiedDate: Optional[Date]
    def datasetCount: Optional[Integer]
    def dataStorage: Optional[Long]
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getDatasetCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("datasetCount", datasetCount)
    def getDataStorage: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("dataStorage", dataStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.IdentityUsage
  ) extends zio.aws.cognitosync.model.IdentityUsage.ReadOnly {
    override val identityId: Optional[IdentityId] = zio.aws.core.internal
      .optionalFromNullable(impl.identityId())
      .map(value => zio.aws.cognitosync.model.primitives.IdentityId(value))
    override val identityPoolId: Optional[IdentityPoolId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityPoolId())
        .map(value =>
          zio.aws.cognitosync.model.primitives.IdentityPoolId(value)
        )
    override val lastModifiedDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
    override val datasetCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetCount())
      .map(value => value: Integer)
    override val dataStorage: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.dataStorage())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.IdentityUsage
  ): zio.aws.cognitosync.model.IdentityUsage.ReadOnly = new Wrapper(impl)
}
