package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.{
  LambdaFunctionArn,
  CognitoEventType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCognitoEventsResponse(
    events: Optional[Map[CognitoEventType, LambdaFunctionArn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsResponse = {
    import GetCognitoEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsResponse
      .builder()
      .optionallyWith(
        events.map(value =>
          value
            .map({ case (key, value) =>
              (CognitoEventType
                .unwrap(key): java.lang.String) -> (LambdaFunctionArn
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.events)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.GetCognitoEventsResponse.ReadOnly =
    zio.aws.cognitosync.model.GetCognitoEventsResponse.wrap(buildAwsValue())
}
object GetCognitoEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.GetCognitoEventsResponse =
      zio.aws.cognitosync.model
        .GetCognitoEventsResponse(events.map(value => value))
    def events: Optional[Map[CognitoEventType, LambdaFunctionArn]]
    def getEvents
        : ZIO[Any, AwsError, Map[CognitoEventType, LambdaFunctionArn]] =
      AwsError.unwrapOptionField("events", events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsResponse
  ) extends zio.aws.cognitosync.model.GetCognitoEventsResponse.ReadOnly {
    override val events: Optional[Map[CognitoEventType, LambdaFunctionArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.events())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cognitosync.model.primitives.CognitoEventType(
                key
              ) -> zio.aws.cognitosync.model.primitives.LambdaFunctionArn(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsResponse
  ): zio.aws.cognitosync.model.GetCognitoEventsResponse.ReadOnly = new Wrapper(
    impl
  )
}
