package zio.aws.cognitosync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cognitosync.model.primitives.{Date, DatasetName, IdentityId}
import scala.jdk.CollectionConverters._
final case class Dataset(
    identityId: Optional[IdentityId] = Optional.Absent,
    datasetName: Optional[DatasetName] = Optional.Absent,
    creationDate: Optional[Date] = Optional.Absent,
    lastModifiedDate: Optional[Date] = Optional.Absent,
    lastModifiedBy: Optional[String] = Optional.Absent,
    dataStorage: Optional[Long] = Optional.Absent,
    numRecords: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.Dataset = {
    import Dataset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.Dataset
      .builder()
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(creationDate.map(value => Date.unwrap(value): Instant))(
        _.creationDate
      )
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(lastModifiedBy.map(value => value: java.lang.String))(
        _.lastModifiedBy
      )
      .optionallyWith(dataStorage.map(value => value: java.lang.Long))(
        _.dataStorage
      )
      .optionallyWith(numRecords.map(value => value: java.lang.Long))(
        _.numRecords
      )
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.Dataset.ReadOnly =
    zio.aws.cognitosync.model.Dataset.wrap(buildAwsValue())
}
object Dataset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.Dataset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.Dataset =
      zio.aws.cognitosync.model.Dataset(
        identityId.map(value => value),
        datasetName.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        lastModifiedBy.map(value => value),
        dataStorage.map(value => value),
        numRecords.map(value => value)
      )
    def identityId: Optional[IdentityId]
    def datasetName: Optional[DatasetName]
    def creationDate: Optional[Date]
    def lastModifiedDate: Optional[Date]
    def lastModifiedBy: Optional[String]
    def dataStorage: Optional[Long]
    def numRecords: Optional[Long]
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getCreationDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLastModifiedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getDataStorage: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("dataStorage", dataStorage)
    def getNumRecords: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("numRecords", numRecords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.Dataset
  ) extends zio.aws.cognitosync.model.Dataset.ReadOnly {
    override val identityId: Optional[IdentityId] = zio.aws.core.internal
      .optionalFromNullable(impl.identityId())
      .map(value => zio.aws.cognitosync.model.primitives.IdentityId(value))
    override val datasetName: Optional[DatasetName] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetName())
      .map(value => zio.aws.cognitosync.model.primitives.DatasetName(value))
    override val creationDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
    override val lastModifiedDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
    override val lastModifiedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedBy())
      .map(value => value: String)
    override val dataStorage: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.dataStorage())
      .map(value => value: Long)
    override val numRecords: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.numRecords())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.Dataset
  ): zio.aws.cognitosync.model.Dataset.ReadOnly = new Wrapper(impl)
}
