package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.IdentityPoolId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetCognitoEventsRequest(identityPoolId: IdentityPoolId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsRequest = {
    import GetCognitoEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.GetCognitoEventsRequest.ReadOnly =
    zio.aws.cognitosync.model.GetCognitoEventsRequest.wrap(buildAwsValue())
}
object GetCognitoEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.GetCognitoEventsRequest =
      zio.aws.cognitosync.model.GetCognitoEventsRequest(identityPoolId)
    def identityPoolId: IdentityPoolId
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsRequest
  ) extends zio.aws.cognitosync.model.GetCognitoEventsRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitosync.model.primitives.IdentityPoolId(impl.identityPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsRequest
  ): zio.aws.cognitosync.model.GetCognitoEventsRequest.ReadOnly = new Wrapper(
    impl
  )
}
