package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.IdentityPoolId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BulkPublishResponse(
    identityPoolId: Optional[IdentityPoolId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.BulkPublishResponse = {
    import BulkPublishResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.BulkPublishResponse
      .builder()
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.BulkPublishResponse.ReadOnly =
    zio.aws.cognitosync.model.BulkPublishResponse.wrap(buildAwsValue())
}
object BulkPublishResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.BulkPublishResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.BulkPublishResponse =
      zio.aws.cognitosync.model
        .BulkPublishResponse(identityPoolId.map(value => value))
    def identityPoolId: Optional[IdentityPoolId]
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.BulkPublishResponse
  ) extends zio.aws.cognitosync.model.BulkPublishResponse.ReadOnly {
    override val identityPoolId: Optional[IdentityPoolId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityPoolId())
        .map(value =>
          zio.aws.cognitosync.model.primitives.IdentityPoolId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.BulkPublishResponse
  ): zio.aws.cognitosync.model.BulkPublishResponse.ReadOnly = new Wrapper(impl)
}
