package zio.aws.cognitosync.model
import scala.jdk.CollectionConverters._
sealed trait StreamingStatus {
  def unwrap: software.amazon.awssdk.services.cognitosync.model.StreamingStatus
}
object StreamingStatus {
  def wrap(
      value: software.amazon.awssdk.services.cognitosync.model.StreamingStatus
  ): zio.aws.cognitosync.model.StreamingStatus = value match {
    case software.amazon.awssdk.services.cognitosync.model.StreamingStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitosync.model.StreamingStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.cognitosync.model.StreamingStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cognitosync.model.StreamingStatus {
    override def unwrap
        : software.amazon.awssdk.services.cognitosync.model.StreamingStatus =
      software.amazon.awssdk.services.cognitosync.model.StreamingStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.cognitosync.model.StreamingStatus {
    override def unwrap
        : software.amazon.awssdk.services.cognitosync.model.StreamingStatus =
      software.amazon.awssdk.services.cognitosync.model.StreamingStatus.ENABLED
  }
  case object DISABLED extends zio.aws.cognitosync.model.StreamingStatus {
    override def unwrap
        : software.amazon.awssdk.services.cognitosync.model.StreamingStatus =
      software.amazon.awssdk.services.cognitosync.model.StreamingStatus.DISABLED
  }
}
