package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.IdentityPoolId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SetIdentityPoolConfigurationRequest(
    identityPoolId: IdentityPoolId,
    pushSync: Option[zio.aws.cognitosync.model.PushSync] = None,
    cognitoStreams: Option[zio.aws.cognitosync.model.CognitoStreams] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationRequest = {
    import SetIdentityPoolConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .optionallyWith(pushSync.map(value => value.buildAwsValue()))(_.pushSync)
      .optionallyWith(cognitoStreams.map(value => value.buildAwsValue()))(
        _.cognitoStreams
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitosync.model.SetIdentityPoolConfigurationRequest.ReadOnly =
    zio.aws.cognitosync.model.SetIdentityPoolConfigurationRequest
      .wrap(buildAwsValue())
}
object SetIdentityPoolConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitosync.model.SetIdentityPoolConfigurationRequest =
      zio.aws.cognitosync.model.SetIdentityPoolConfigurationRequest(
        identityPoolId,
        pushSync.map(value => value.asEditable),
        cognitoStreams.map(value => value.asEditable)
      )
    def identityPoolId: IdentityPoolId
    def pushSync: Option[zio.aws.cognitosync.model.PushSync.ReadOnly]
    def cognitoStreams
        : Option[zio.aws.cognitosync.model.CognitoStreams.ReadOnly]
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getPushSync
        : ZIO[Any, AwsError, zio.aws.cognitosync.model.PushSync.ReadOnly] =
      AwsError.unwrapOptionField("pushSync", pushSync)
    def getCognitoStreams: ZIO[
      Any,
      AwsError,
      zio.aws.cognitosync.model.CognitoStreams.ReadOnly
    ] = AwsError.unwrapOptionField("cognitoStreams", cognitoStreams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationRequest
  ) extends zio.aws.cognitosync.model.SetIdentityPoolConfigurationRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitosync.model.primitives.IdentityPoolId(impl.identityPoolId())
    override val pushSync: Option[zio.aws.cognitosync.model.PushSync.ReadOnly] =
      scala
        .Option(impl.pushSync())
        .map(value => zio.aws.cognitosync.model.PushSync.wrap(value))
    override val cognitoStreams
        : Option[zio.aws.cognitosync.model.CognitoStreams.ReadOnly] = scala
      .Option(impl.cognitoStreams())
      .map(value => zio.aws.cognitosync.model.CognitoStreams.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationRequest
  ): zio.aws.cognitosync.model.SetIdentityPoolConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
