package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.{Date, RecordValue, RecordKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Record(
    key: Option[RecordKey] = None,
    value: Option[RecordValue] = None,
    syncCount: Option[Long] = None,
    lastModifiedDate: Option[Date] = None,
    lastModifiedBy: Option[String] = None,
    deviceLastModifiedDate: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.Record = {
    import Record.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.Record
      .builder()
      .optionallyWith(
        key.map(value => RecordKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => RecordValue.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(syncCount.map(value => value: java.lang.Long))(
        _.syncCount
      )
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(lastModifiedBy.map(value => value: java.lang.String))(
        _.lastModifiedBy
      )
      .optionallyWith(
        deviceLastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.deviceLastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.Record.ReadOnly =
    zio.aws.cognitosync.model.Record.wrap(buildAwsValue())
}
object Record {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.Record
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.Record =
      zio.aws.cognitosync.model.Record(
        key.map(value => value),
        value.map(value => value),
        syncCount.map(value => value),
        lastModifiedDate.map(value => value),
        lastModifiedBy.map(value => value),
        deviceLastModifiedDate.map(value => value)
      )
    def key: Option[RecordKey]
    def value: Option[RecordValue]
    def syncCount: Option[Long]
    def lastModifiedDate: Option[Date]
    def lastModifiedBy: Option[String]
    def deviceLastModifiedDate: Option[Date]
    def getKey: ZIO[Any, AwsError, RecordKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, RecordValue] =
      AwsError.unwrapOptionField("value", value)
    def getSyncCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("syncCount", syncCount)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLastModifiedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getDeviceLastModifiedDate: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("deviceLastModifiedDate", deviceLastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.Record
  ) extends zio.aws.cognitosync.model.Record.ReadOnly {
    override val key: Option[RecordKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.cognitosync.model.primitives.RecordKey(value))
    override val value: Option[RecordValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.cognitosync.model.primitives.RecordValue(value))
    override val syncCount: Option[Long] =
      scala.Option(impl.syncCount()).map(value => value: Long)
    override val lastModifiedDate: Option[Date] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
    override val lastModifiedBy: Option[String] =
      scala.Option(impl.lastModifiedBy()).map(value => value: String)
    override val deviceLastModifiedDate: Option[Date] = scala
      .Option(impl.deviceLastModifiedDate())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.Record
  ): zio.aws.cognitosync.model.Record.ReadOnly = new Wrapper(impl)
}
