package zio.aws.cognitosync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeIdentityUsageResponse(
    identityUsage: Option[zio.aws.cognitosync.model.IdentityUsage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageResponse = {
    import DescribeIdentityUsageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageResponse
      .builder()
      .optionallyWith(identityUsage.map(value => value.buildAwsValue()))(
        _.identityUsage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitosync.model.DescribeIdentityUsageResponse.ReadOnly =
    zio.aws.cognitosync.model.DescribeIdentityUsageResponse
      .wrap(buildAwsValue())
}
object DescribeIdentityUsageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.DescribeIdentityUsageResponse =
      zio.aws.cognitosync.model.DescribeIdentityUsageResponse(
        identityUsage.map(value => value.asEditable)
      )
    def identityUsage: Option[zio.aws.cognitosync.model.IdentityUsage.ReadOnly]
    def getIdentityUsage
        : ZIO[Any, AwsError, zio.aws.cognitosync.model.IdentityUsage.ReadOnly] =
      AwsError.unwrapOptionField("identityUsage", identityUsage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageResponse
  ) extends zio.aws.cognitosync.model.DescribeIdentityUsageResponse.ReadOnly {
    override val identityUsage
        : Option[zio.aws.cognitosync.model.IdentityUsage.ReadOnly] = scala
      .Option(impl.identityUsage())
      .map(value => zio.aws.cognitosync.model.IdentityUsage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageResponse
  ): zio.aws.cognitosync.model.DescribeIdentityUsageResponse.ReadOnly =
    new Wrapper(impl)
}
