package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.{
  DatasetName,
  IdentityId,
  IdentityPoolId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDatasetRequest(
    identityPoolId: IdentityPoolId,
    identityId: IdentityId,
    datasetName: DatasetName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.DeleteDatasetRequest = {
    import DeleteDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.DeleteDatasetRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .identityId(IdentityId.unwrap(identityId): java.lang.String)
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.DeleteDatasetRequest.ReadOnly =
    zio.aws.cognitosync.model.DeleteDatasetRequest.wrap(buildAwsValue())
}
object DeleteDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.DeleteDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.DeleteDatasetRequest =
      zio.aws.cognitosync.model
        .DeleteDatasetRequest(identityPoolId, identityId, datasetName)
    def identityPoolId: IdentityPoolId
    def identityId: IdentityId
    def datasetName: DatasetName
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getIdentityId: ZIO[Any, Nothing, IdentityId] = ZIO.succeed(identityId)
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.DeleteDatasetRequest
  ) extends zio.aws.cognitosync.model.DeleteDatasetRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitosync.model.primitives.IdentityPoolId(impl.identityPoolId())
    override val identityId: IdentityId =
      zio.aws.cognitosync.model.primitives.IdentityId(impl.identityId())
    override val datasetName: DatasetName =
      zio.aws.cognitosync.model.primitives.DatasetName(impl.datasetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.DeleteDatasetRequest
  ): zio.aws.cognitosync.model.DeleteDatasetRequest.ReadOnly = new Wrapper(impl)
}
