package zio.aws.cognitosync.model
import scala.jdk.CollectionConverters._
sealed trait Operation {
  def unwrap: software.amazon.awssdk.services.cognitosync.model.Operation
}
object Operation {
  def wrap(
      value: software.amazon.awssdk.services.cognitosync.model.Operation
  ): zio.aws.cognitosync.model.Operation = value match {
    case software.amazon.awssdk.services.cognitosync.model.Operation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cognitosync.model.Operation.REPLACE =>
      val r = replace
      r
    case software.amazon.awssdk.services.cognitosync.model.Operation.REMOVE =>
      val r = remove
      r
  }
  case object unknownToSdkVersion extends zio.aws.cognitosync.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.cognitosync.model.Operation =
      software.amazon.awssdk.services.cognitosync.model.Operation.UNKNOWN_TO_SDK_VERSION
  }
  case object replace extends zio.aws.cognitosync.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.cognitosync.model.Operation =
      software.amazon.awssdk.services.cognitosync.model.Operation.REPLACE
  }
  case object remove extends zio.aws.cognitosync.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.cognitosync.model.Operation =
      software.amazon.awssdk.services.cognitosync.model.Operation.REMOVE
  }
}
