package zio.aws.cognitosync.model
import java.lang.Integer
import zio.aws.cognitosync.model.primitives.{
  IntegerString,
  IdentityId,
  IdentityPoolId,
  SyncSessionToken,
  DatasetName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListRecordsRequest(
    identityPoolId: IdentityPoolId,
    identityId: IdentityId,
    datasetName: DatasetName,
    lastSyncCount: Option[Long] = None,
    nextToken: Option[String] = None,
    maxResults: Option[IntegerString] = None,
    syncSessionToken: Option[SyncSessionToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest = {
    import ListRecordsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .identityId(IdentityId.unwrap(identityId): java.lang.String)
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .optionallyWith(lastSyncCount.map(value => value: java.lang.Long))(
        _.lastSyncCount
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => IntegerString.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        syncSessionToken.map(value =>
          SyncSessionToken.unwrap(value): java.lang.String
        )
      )(_.syncSessionToken)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.ListRecordsRequest.ReadOnly =
    zio.aws.cognitosync.model.ListRecordsRequest.wrap(buildAwsValue())
}
object ListRecordsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.ListRecordsRequest =
      zio.aws.cognitosync.model.ListRecordsRequest(
        identityPoolId,
        identityId,
        datasetName,
        lastSyncCount.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        syncSessionToken.map(value => value)
      )
    def identityPoolId: IdentityPoolId
    def identityId: IdentityId
    def datasetName: DatasetName
    def lastSyncCount: Option[Long]
    def nextToken: Option[String]
    def maxResults: Option[IntegerString]
    def syncSessionToken: Option[SyncSessionToken]
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getIdentityId: ZIO[Any, Nothing, IdentityId] = ZIO.succeed(identityId)
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
    def getLastSyncCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("lastSyncCount", lastSyncCount)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, IntegerString] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSyncSessionToken: ZIO[Any, AwsError, SyncSessionToken] =
      AwsError.unwrapOptionField("syncSessionToken", syncSessionToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest
  ) extends zio.aws.cognitosync.model.ListRecordsRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitosync.model.primitives.IdentityPoolId(impl.identityPoolId())
    override val identityId: IdentityId =
      zio.aws.cognitosync.model.primitives.IdentityId(impl.identityId())
    override val datasetName: DatasetName =
      zio.aws.cognitosync.model.primitives.DatasetName(impl.datasetName())
    override val lastSyncCount: Option[Long] =
      scala.Option(impl.lastSyncCount()).map(value => value: Long)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[IntegerString] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.cognitosync.model.primitives.IntegerString(value))
    override val syncSessionToken: Option[SyncSessionToken] = scala
      .Option(impl.syncSessionToken())
      .map(value =>
        zio.aws.cognitosync.model.primitives.SyncSessionToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest
  ): zio.aws.cognitosync.model.ListRecordsRequest.ReadOnly = new Wrapper(impl)
}
