package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListIdentityPoolUsageResponse(
    identityPoolUsages: Option[
      Iterable[zio.aws.cognitosync.model.IdentityPoolUsage]
    ] = None,
    maxResults: Option[Integer] = None,
    count: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageResponse = {
    import ListIdentityPoolUsageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageResponse
      .builder()
      .optionallyWith(
        identityPoolUsages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.identityPoolUsages)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitosync.model.ListIdentityPoolUsageResponse.ReadOnly =
    zio.aws.cognitosync.model.ListIdentityPoolUsageResponse
      .wrap(buildAwsValue())
}
object ListIdentityPoolUsageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.ListIdentityPoolUsageResponse =
      zio.aws.cognitosync.model.ListIdentityPoolUsageResponse(
        identityPoolUsages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        count.map(value => value),
        nextToken.map(value => value)
      )
    def identityPoolUsages
        : Option[List[zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly]]
    def maxResults: Option[Integer]
    def count: Option[Integer]
    def nextToken: Option[String]
    def getIdentityPoolUsages: ZIO[Any, AwsError, List[
      zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly
    ]] = AwsError.unwrapOptionField("identityPoolUsages", identityPoolUsages)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageResponse
  ) extends zio.aws.cognitosync.model.ListIdentityPoolUsageResponse.ReadOnly {
    override val identityPoolUsages
        : Option[List[zio.aws.cognitosync.model.IdentityPoolUsage.ReadOnly]] =
      scala
        .Option(impl.identityPoolUsages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cognitosync.model.IdentityPoolUsage.wrap(item)
          }.toList
        )
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val count: Option[Integer] =
      scala.Option(impl.count()).map(value => value: Integer)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageResponse
  ): zio.aws.cognitosync.model.ListIdentityPoolUsageResponse.ReadOnly =
    new Wrapper(impl)
}
