package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.IdentityPoolId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetIdentityPoolConfigurationResponse(
    identityPoolId: Option[IdentityPoolId] = None,
    pushSync: Option[zio.aws.cognitosync.model.PushSync] = None,
    cognitoStreams: Option[zio.aws.cognitosync.model.CognitoStreams] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationResponse = {
    import GetIdentityPoolConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationResponse
      .builder()
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .optionallyWith(pushSync.map(value => value.buildAwsValue()))(_.pushSync)
      .optionallyWith(cognitoStreams.map(value => value.buildAwsValue()))(
        _.cognitoStreams
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse.ReadOnly =
    zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse
      .wrap(buildAwsValue())
}
object GetIdentityPoolConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse =
      zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse(
        identityPoolId.map(value => value),
        pushSync.map(value => value.asEditable),
        cognitoStreams.map(value => value.asEditable)
      )
    def identityPoolId: Option[IdentityPoolId]
    def pushSync: Option[zio.aws.cognitosync.model.PushSync.ReadOnly]
    def cognitoStreams
        : Option[zio.aws.cognitosync.model.CognitoStreams.ReadOnly]
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getPushSync
        : ZIO[Any, AwsError, zio.aws.cognitosync.model.PushSync.ReadOnly] =
      AwsError.unwrapOptionField("pushSync", pushSync)
    def getCognitoStreams: ZIO[
      Any,
      AwsError,
      zio.aws.cognitosync.model.CognitoStreams.ReadOnly
    ] = AwsError.unwrapOptionField("cognitoStreams", cognitoStreams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationResponse
  ) extends zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse.ReadOnly {
    override val identityPoolId: Option[IdentityPoolId] = scala
      .Option(impl.identityPoolId())
      .map(value => zio.aws.cognitosync.model.primitives.IdentityPoolId(value))
    override val pushSync: Option[zio.aws.cognitosync.model.PushSync.ReadOnly] =
      scala
        .Option(impl.pushSync())
        .map(value => zio.aws.cognitosync.model.PushSync.wrap(value))
    override val cognitoStreams
        : Option[zio.aws.cognitosync.model.CognitoStreams.ReadOnly] = scala
      .Option(impl.cognitoStreams())
      .map(value => zio.aws.cognitosync.model.CognitoStreams.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationResponse
  ): zio.aws.cognitosync.model.GetIdentityPoolConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
