package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.{Date, RecordValue, RecordKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class RecordPatch(
    op: zio.aws.cognitosync.model.Operation,
    key: RecordKey,
    value: Option[RecordValue] = None,
    syncCount: Long,
    deviceLastModifiedDate: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.RecordPatch = {
    import RecordPatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.RecordPatch
      .builder()
      .op(op.unwrap)
      .key(RecordKey.unwrap(key): java.lang.String)
      .optionallyWith(
        value.map(value => RecordValue.unwrap(value): java.lang.String)
      )(_.value)
      .syncCount(syncCount: java.lang.Long)
      .optionallyWith(
        deviceLastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.deviceLastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.RecordPatch.ReadOnly =
    zio.aws.cognitosync.model.RecordPatch.wrap(buildAwsValue())
}
object RecordPatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.RecordPatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.RecordPatch =
      zio.aws.cognitosync.model.RecordPatch(
        op,
        key,
        value.map(value => value),
        syncCount,
        deviceLastModifiedDate.map(value => value)
      )
    def op: zio.aws.cognitosync.model.Operation
    def key: RecordKey
    def value: Option[RecordValue]
    def syncCount: Long
    def deviceLastModifiedDate: Option[Date]
    def getOp: ZIO[Any, Nothing, zio.aws.cognitosync.model.Operation] =
      ZIO.succeed(op)
    def getKey: ZIO[Any, Nothing, RecordKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, AwsError, RecordValue] =
      AwsError.unwrapOptionField("value", value)
    def getSyncCount: ZIO[Any, Nothing, Long] = ZIO.succeed(syncCount)
    def getDeviceLastModifiedDate: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("deviceLastModifiedDate", deviceLastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.RecordPatch
  ) extends zio.aws.cognitosync.model.RecordPatch.ReadOnly {
    override val op: zio.aws.cognitosync.model.Operation =
      zio.aws.cognitosync.model.Operation.wrap(impl.op())
    override val key: RecordKey =
      zio.aws.cognitosync.model.primitives.RecordKey(impl.key())
    override val value: Option[RecordValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.cognitosync.model.primitives.RecordValue(value))
    override val syncCount: Long = impl.syncCount(): Long
    override val deviceLastModifiedDate: Option[Date] = scala
      .Option(impl.deviceLastModifiedDate())
      .map(value => zio.aws.cognitosync.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.RecordPatch
  ): zio.aws.cognitosync.model.RecordPatch.ReadOnly = new Wrapper(impl)
}
