package zio.aws.cognitosync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDatasetResponse(
    dataset: Option[zio.aws.cognitosync.model.Dataset] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.DescribeDatasetResponse = {
    import DescribeDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.DescribeDatasetResponse
      .builder()
      .optionallyWith(dataset.map(value => value.buildAwsValue()))(_.dataset)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.DescribeDatasetResponse.ReadOnly =
    zio.aws.cognitosync.model.DescribeDatasetResponse.wrap(buildAwsValue())
}
object DescribeDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.DescribeDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.DescribeDatasetResponse =
      zio.aws.cognitosync.model
        .DescribeDatasetResponse(dataset.map(value => value.asEditable))
    def dataset: Option[zio.aws.cognitosync.model.Dataset.ReadOnly]
    def getDataset
        : ZIO[Any, AwsError, zio.aws.cognitosync.model.Dataset.ReadOnly] =
      AwsError.unwrapOptionField("dataset", dataset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.DescribeDatasetResponse
  ) extends zio.aws.cognitosync.model.DescribeDatasetResponse.ReadOnly {
    override val dataset: Option[zio.aws.cognitosync.model.Dataset.ReadOnly] =
      scala
        .Option(impl.dataset())
        .map(value => zio.aws.cognitosync.model.Dataset.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.DescribeDatasetResponse
  ): zio.aws.cognitosync.model.DescribeDatasetResponse.ReadOnly = new Wrapper(
    impl
  )
}
