package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.{AssumeRoleArn, StreamName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CognitoStreams(
    streamName: Option[StreamName] = None,
    roleArn: Option[AssumeRoleArn] = None,
    streamingStatus: Option[zio.aws.cognitosync.model.StreamingStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.CognitoStreams = {
    import CognitoStreams.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.CognitoStreams
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        roleArn.map(value => AssumeRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(streamingStatus.map(value => value.unwrap))(
        _.streamingStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.CognitoStreams.ReadOnly =
    zio.aws.cognitosync.model.CognitoStreams.wrap(buildAwsValue())
}
object CognitoStreams {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.CognitoStreams
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.CognitoStreams =
      zio.aws.cognitosync.model.CognitoStreams(
        streamName.map(value => value),
        roleArn.map(value => value),
        streamingStatus.map(value => value)
      )
    def streamName: Option[StreamName]
    def roleArn: Option[AssumeRoleArn]
    def streamingStatus: Option[zio.aws.cognitosync.model.StreamingStatus]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getRoleArn: ZIO[Any, AwsError, AssumeRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStreamingStatus
        : ZIO[Any, AwsError, zio.aws.cognitosync.model.StreamingStatus] =
      AwsError.unwrapOptionField("streamingStatus", streamingStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.CognitoStreams
  ) extends zio.aws.cognitosync.model.CognitoStreams.ReadOnly {
    override val streamName: Option[StreamName] = scala
      .Option(impl.streamName())
      .map(value => zio.aws.cognitosync.model.primitives.StreamName(value))
    override val roleArn: Option[AssumeRoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.cognitosync.model.primitives.AssumeRoleArn(value))
    override val streamingStatus
        : Option[zio.aws.cognitosync.model.StreamingStatus] = scala
      .Option(impl.streamingStatus())
      .map(value => zio.aws.cognitosync.model.StreamingStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.CognitoStreams
  ): zio.aws.cognitosync.model.CognitoStreams.ReadOnly = new Wrapper(impl)
}
