package zio.aws.cognitosync
import zio.prelude.Subtype
import zio.aws.cognitosync.model.primitives.{
  LambdaFunctionArn,
  CognitoEventType,
  ApplicationArn
}
import java.time.Instant
import zio.aws.cognitosync.model.primitives.RecordValue.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ApplicationArn extends Subtype[String]
    type ApplicationArn =
      zio.aws.cognitosync.model.primitives.ApplicationArn.Type
    object AssumeRoleArn extends Subtype[String]
    type AssumeRoleArn = zio.aws.cognitosync.model.primitives.AssumeRoleArn.Type
    object ClientContext extends Subtype[String]
    type ClientContext = zio.aws.cognitosync.model.primitives.ClientContext.Type
    object CognitoEventType extends Subtype[String]
    type CognitoEventType =
      zio.aws.cognitosync.model.primitives.CognitoEventType.Type
    object DatasetName extends Subtype[String]
    type DatasetName = zio.aws.cognitosync.model.primitives.DatasetName.Type
    object Date extends Subtype[Instant]
    type Date = zio.aws.cognitosync.model.primitives.Date.Type
    object DeviceId extends Subtype[String]
    type DeviceId = zio.aws.cognitosync.model.primitives.DeviceId.Type
    object IdentityId extends Subtype[String]
    type IdentityId = zio.aws.cognitosync.model.primitives.IdentityId.Type
    object IdentityPoolId extends Subtype[String]
    type IdentityPoolId =
      zio.aws.cognitosync.model.primitives.IdentityPoolId.Type
    object Integer extends Subtype[Int]
    type Integer = zio.aws.cognitosync.model.primitives.Integer.Type
    object IntegerString extends Subtype[Int]
    type IntegerString = zio.aws.cognitosync.model.primitives.IntegerString.Type
    object LambdaFunctionArn extends Subtype[String]
    type LambdaFunctionArn =
      zio.aws.cognitosync.model.primitives.LambdaFunctionArn.Type
    object PushToken extends Subtype[String]
    type PushToken = zio.aws.cognitosync.model.primitives.PushToken.Type
    object RecordKey extends Subtype[String]
    type RecordKey = zio.aws.cognitosync.model.primitives.RecordKey.Type
    object RecordValue extends Subtype[String]
    type RecordValue = zio.aws.cognitosync.model.primitives.RecordValue.Type
    object StreamName extends Subtype[String]
    type StreamName = zio.aws.cognitosync.model.primitives.StreamName.Type
    object SyncSessionToken extends Subtype[String]
    type SyncSessionToken =
      zio.aws.cognitosync.model.primitives.SyncSessionToken.Type
  }
  type ApplicationArnList = List[ApplicationArn]
  type DatasetList = List[zio.aws.cognitosync.model.Dataset]
  type Events = Map[CognitoEventType, LambdaFunctionArn]
  type IdentityPoolUsageList = List[zio.aws.cognitosync.model.IdentityPoolUsage]
  type MergedDatasetNameList = List[String]
  type RecordList = List[zio.aws.cognitosync.model.Record]
  type RecordPatchList = List[zio.aws.cognitosync.model.RecordPatch]
}
