package zio.aws.cognitosync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateRecordsResponse(
    records: Option[Iterable[zio.aws.cognitosync.model.Record]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.UpdateRecordsResponse = {
    import UpdateRecordsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.UpdateRecordsResponse
      .builder()
      .optionallyWith(
        records.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.records)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.UpdateRecordsResponse.ReadOnly =
    zio.aws.cognitosync.model.UpdateRecordsResponse.wrap(buildAwsValue())
}
object UpdateRecordsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.UpdateRecordsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.UpdateRecordsResponse =
      zio.aws.cognitosync.model.UpdateRecordsResponse(
        records.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def records: Option[List[zio.aws.cognitosync.model.Record.ReadOnly]]
    def getRecords
        : ZIO[Any, AwsError, List[zio.aws.cognitosync.model.Record.ReadOnly]] =
      AwsError.unwrapOptionField("records", records)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.UpdateRecordsResponse
  ) extends zio.aws.cognitosync.model.UpdateRecordsResponse.ReadOnly {
    override val records
        : Option[List[zio.aws.cognitosync.model.Record.ReadOnly]] = scala
      .Option(impl.records())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitosync.model.Record.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.UpdateRecordsResponse
  ): zio.aws.cognitosync.model.UpdateRecordsResponse.ReadOnly = new Wrapper(
    impl
  )
}
