package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.{
  DeviceId,
  IdentityId,
  IdentityPoolId,
  SyncSessionToken,
  DatasetName,
  ClientContext
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateRecordsRequest(
    identityPoolId: IdentityPoolId,
    identityId: IdentityId,
    datasetName: DatasetName,
    deviceId: Option[DeviceId] = None,
    recordPatches: Option[Iterable[zio.aws.cognitosync.model.RecordPatch]] =
      None,
    syncSessionToken: SyncSessionToken,
    clientContext: Option[ClientContext] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.UpdateRecordsRequest = {
    import UpdateRecordsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.UpdateRecordsRequest
      .builder()
      .identityPoolId(IdentityPoolId.unwrap(identityPoolId): java.lang.String)
      .identityId(IdentityId.unwrap(identityId): java.lang.String)
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        recordPatches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recordPatches)
      .syncSessionToken(
        SyncSessionToken.unwrap(syncSessionToken): java.lang.String
      )
      .optionallyWith(
        clientContext.map(value =>
          ClientContext.unwrap(value): java.lang.String
        )
      )(_.clientContext)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.UpdateRecordsRequest.ReadOnly =
    zio.aws.cognitosync.model.UpdateRecordsRequest.wrap(buildAwsValue())
}
object UpdateRecordsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.UpdateRecordsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.UpdateRecordsRequest =
      zio.aws.cognitosync.model.UpdateRecordsRequest(
        identityPoolId,
        identityId,
        datasetName,
        deviceId.map(value => value),
        recordPatches.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        syncSessionToken,
        clientContext.map(value => value)
      )
    def identityPoolId: IdentityPoolId
    def identityId: IdentityId
    def datasetName: DatasetName
    def deviceId: Option[DeviceId]
    def recordPatches
        : Option[List[zio.aws.cognitosync.model.RecordPatch.ReadOnly]]
    def syncSessionToken: SyncSessionToken
    def clientContext: Option[ClientContext]
    def getIdentityPoolId: ZIO[Any, Nothing, IdentityPoolId] =
      ZIO.succeed(identityPoolId)
    def getIdentityId: ZIO[Any, Nothing, IdentityId] = ZIO.succeed(identityId)
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getRecordPatches: ZIO[Any, AwsError, List[
      zio.aws.cognitosync.model.RecordPatch.ReadOnly
    ]] = AwsError.unwrapOptionField("recordPatches", recordPatches)
    def getSyncSessionToken: ZIO[Any, Nothing, SyncSessionToken] =
      ZIO.succeed(syncSessionToken)
    def getClientContext: ZIO[Any, AwsError, ClientContext] =
      AwsError.unwrapOptionField("clientContext", clientContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.UpdateRecordsRequest
  ) extends zio.aws.cognitosync.model.UpdateRecordsRequest.ReadOnly {
    override val identityPoolId: IdentityPoolId =
      zio.aws.cognitosync.model.primitives.IdentityPoolId(impl.identityPoolId())
    override val identityId: IdentityId =
      zio.aws.cognitosync.model.primitives.IdentityId(impl.identityId())
    override val datasetName: DatasetName =
      zio.aws.cognitosync.model.primitives.DatasetName(impl.datasetName())
    override val deviceId: Option[DeviceId] = scala
      .Option(impl.deviceId())
      .map(value => zio.aws.cognitosync.model.primitives.DeviceId(value))
    override val recordPatches
        : Option[List[zio.aws.cognitosync.model.RecordPatch.ReadOnly]] = scala
      .Option(impl.recordPatches())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cognitosync.model.RecordPatch.wrap(item)
        }.toList
      )
    override val syncSessionToken: SyncSessionToken =
      zio.aws.cognitosync.model.primitives
        .SyncSessionToken(impl.syncSessionToken())
    override val clientContext: Option[ClientContext] = scala
      .Option(impl.clientContext())
      .map(value => zio.aws.cognitosync.model.primitives.ClientContext(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.UpdateRecordsRequest
  ): zio.aws.cognitosync.model.UpdateRecordsRequest.ReadOnly = new Wrapper(impl)
}
