package zio.aws.cognitosync.model
import zio.aws.cognitosync.model.primitives.DeviceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RegisterDeviceResponse(deviceId: Option[DeviceId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cognitosync.model.RegisterDeviceResponse = {
    import RegisterDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cognitosync.model.RegisterDeviceResponse
      .builder()
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .build()
  }
  def asReadOnly: zio.aws.cognitosync.model.RegisterDeviceResponse.ReadOnly =
    zio.aws.cognitosync.model.RegisterDeviceResponse.wrap(buildAwsValue())
}
object RegisterDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cognitosync.model.RegisterDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cognitosync.model.RegisterDeviceResponse =
      zio.aws.cognitosync.model
        .RegisterDeviceResponse(deviceId.map(value => value))
    def deviceId: Option[DeviceId]
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cognitosync.model.RegisterDeviceResponse
  ) extends zio.aws.cognitosync.model.RegisterDeviceResponse.ReadOnly {
    override val deviceId: Option[DeviceId] = scala
      .Option(impl.deviceId())
      .map(value => zio.aws.cognitosync.model.primitives.DeviceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cognitosync.model.RegisterDeviceResponse
  ): zio.aws.cognitosync.model.RegisterDeviceResponse.ReadOnly = new Wrapper(
    impl
  )
}
